Ext.data.JsonP.sol_common_forms_Utils({"tagname":"class","name":"sol.common.forms.Utils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.forms.Utils.js","href":"lib_sol.common.forms.Utils.html#sol-common-forms-Utils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.03.006"],"requires":["sol.common.ObjectUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"keyCodeArrowDown","tagname":"property","owner":"sol.common.forms.Utils","id":"property-keyCodeArrowDown","meta":{"private":true}},{"name":"keyCodeArrowLeft","tagname":"property","owner":"sol.common.forms.Utils","id":"property-keyCodeArrowLeft","meta":{"private":true}},{"name":"keyCodeArrowRight","tagname":"property","owner":"sol.common.forms.Utils","id":"property-keyCodeArrowRight","meta":{"private":true}},{"name":"keyCodeArrowUp","tagname":"property","owner":"sol.common.forms.Utils","id":"property-keyCodeArrowUp","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"unitSuffix","tagname":"property","owner":"sol.common.forms.Utils","id":"property-unitSuffix","meta":{"private":true}},{"name":"wfMapSavedFlag","tagname":"property","owner":"sol.common.forms.Utils","id":"property-wfMapSavedFlag","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"MultiIndex","tagname":"method","owner":"sol.common.forms.Utils","id":"method-MultiIndex","meta":{}},{"name":"addBodyClass","tagname":"method","owner":"sol.common.forms.Utils","id":"method-addBodyClass","meta":{}},{"name":"addClickListener","tagname":"method","owner":"sol.common.forms.Utils","id":"method-addClickListener","meta":{}},{"name":"addJsAddLineButtonListener","tagname":"method","owner":"sol.common.forms.Utils","id":"method-addJsAddLineButtonListener","meta":{}},{"name":"addListener","tagname":"method","owner":"sol.common.forms.Utils","id":"method-addListener","meta":{}},{"name":"applyUserImage","tagname":"method","owner":"sol.common.forms.Utils","id":"method-applyUserImage","meta":{}},{"name":"applyUserImages","tagname":"method","owner":"sol.common.forms.Utils","id":"method-applyUserImages","meta":{}},{"name":"callInputChangedForDynKwlChanges","tagname":"method","owner":"sol.common.forms.Utils","id":"method-callInputChangedForDynKwlChanges","meta":{}},{"name":"callRegisteredFunction","tagname":"method","owner":"sol.common.forms.Utils","id":"method-callRegisteredFunction","meta":{}},{"name":"checkMandatoryFields","tagname":"method","owner":"sol.common.forms.Utils","id":"method-checkMandatoryFields","meta":{}},{"name":"checkSource","tagname":"method","owner":"sol.common.forms.Utils","id":"method-checkSource","meta":{}},{"name":"checkVersion","tagname":"method","owner":"sol.common.forms.Utils","id":"method-checkVersion","meta":{}},{"name":"clearRemainingLines","tagname":"method","owner":"sol.common.forms.Utils","id":"method-clearRemainingLines","meta":{}},{"name":"columnExists","tagname":"method","owner":"sol.common.forms.Utils","id":"method-columnExists","meta":{}},{"name":"copyIsoDate","tagname":"method","owner":"sol.common.forms.Utils","id":"method-copyIsoDate","meta":{}},{"name":"countLines","tagname":"method","owner":"sol.common.forms.Utils","id":"method-countLines","meta":{}},{"name":"disableCancelButtonValidation","tagname":"method","owner":"sol.common.forms.Utils","id":"method-disableCancelButtonValidation","meta":{}},{"name":"disableColumn","tagname":"method","owner":"sol.common.forms.Utils","id":"method-disableColumn","meta":{}},{"name":"disableDependentFields","tagname":"method","owner":"sol.common.forms.Utils","id":"method-disableDependentFields","meta":{}},{"name":"disableField","tagname":"method","owner":"sol.common.forms.Utils","id":"method-disableField","meta":{}},{"name":"disableFields","tagname":"method","owner":"sol.common.forms.Utils","id":"method-disableFields","meta":{}},{"name":"disableForwardButtons","tagname":"method","owner":"sol.common.forms.Utils","id":"method-disableForwardButtons","meta":{}},{"name":"disableRowsByIndicatorField","tagname":"method","owner":"sol.common.forms.Utils","id":"method-disableRowsByIndicatorField","meta":{}},{"name":"enableRow","tagname":"method","owner":"sol.common.forms.Utils","id":"method-enableRow","meta":{}},{"name":"encodeParams","tagname":"method","owner":"sol.common.forms.Utils","id":"method-encodeParams","meta":{}},{"name":"ensureRowExists","tagname":"method","owner":"sol.common.forms.Utils","id":"method-ensureRowExists","meta":{}},{"name":"fieldExists","tagname":"method","owner":"sol.common.forms.Utils","id":"method-fieldExists","meta":{}},{"name":"forEachRow","tagname":"method","owner":"sol.common.forms.Utils","id":"method-forEachRow","meta":{}},{"name":"getAddLineButton","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getAddLineButton","meta":{}},{"name":"getAppApiUrl","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getAppApiUrl","meta":{}},{"name":"getAppUrl","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getAppUrl","meta":{}},{"name":"getAsBaseUrl","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getAsBaseUrl","meta":{}},{"name":"getBaseFieldName","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getBaseFieldName","meta":{}},{"name":"getCell","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getCell","meta":{}},{"name":"getColumnIndex","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getColumnIndex","meta":{}},{"name":"getDisplayDecimalPlaces","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getDisplayDecimalPlaces","meta":{}},{"name":"getElementsInRow","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getElementsInRow","meta":{}},{"name":"getFieldNameIndex","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getFieldNameIndex","meta":{}},{"name":"getFieldNamePrefix","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getFieldNamePrefix","meta":{}},{"name":"getFormLanguage","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getFormLanguage","meta":{}},{"name":"getForwardButton","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getForwardButton","meta":{}},{"name":"getForwardButtons","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getForwardButtons","meta":{}},{"name":"getInputDataType","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getInputDataType","meta":{}},{"name":"getInputsInRow","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getInputsInRow","meta":{}},{"name":"getIsoDate","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getIsoDate","meta":{}},{"name":"getJsAddLineButton","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getJsAddLineButton","meta":{}},{"name":"getJsAddLineButtonById","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getJsAddLineButtonById","meta":{}},{"name":"getJsAddLineRowById","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getJsAddLineRowById","meta":{}},{"name":"getLastInput","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getLastInput","meta":{}},{"name":"getLocation","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getLocation","meta":{}},{"name":"getNextButtonIndex","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getNextButtonIndex","meta":{}},{"name":"getNextButtonTranslationKey","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getNextButtonTranslationKey","meta":{}},{"name":"getNextHorizontalField","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getNextHorizontalField","meta":{"private":true}},{"name":"getNextVerticalField","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getNextVerticalField","meta":{"private":true}},{"name":"getNextWriteableHorizontalField","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getNextWriteableHorizontalField","meta":{"private":true}},{"name":"getNextWriteableVerticalField","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getNextWriteableVerticalField","meta":{"private":true}},{"name":"getParentByTagName","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getParentByTagName","meta":{}},{"name":"getParentTable","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getParentTable","meta":{}},{"name":"getRow","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getRow","meta":{}},{"name":"getRowIndex","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getRowIndex","meta":{}},{"name":"getTable","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getTable","meta":{}},{"name":"getTemplate","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getTemplate","meta":{}},{"name":"getTemplateSord","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getTemplateSord","meta":{}},{"name":"getUserImageUrl","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getUserImageUrl","meta":{}},{"name":"getWfUrl","tagname":"method","owner":"sol.common.forms.Utils","id":"method-getWfUrl","meta":{}},{"name":"gotoSord","tagname":"method","owner":"sol.common.forms.Utils","id":"method-gotoSord","meta":{}},{"name":"hideTabBarIfOnlyOneTab","tagname":"method","owner":"sol.common.forms.Utils","id":"method-hideTabBarIfOnlyOneTab","meta":{}},{"name":"hideTemplate","tagname":"method","owner":"sol.common.forms.Utils","id":"method-hideTemplate","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"initializeForm","tagname":"method","owner":"sol.common.forms.Utils","id":"method-initializeForm","meta":{}},{"name":"initializeIxSession","tagname":"method","owner":"sol.common.forms.Utils","id":"method-initializeIxSession","meta":{}},{"name":"isArrowKey","tagname":"method","owner":"sol.common.forms.Utils","id":"method-isArrowKey","meta":{}},{"name":"isColumnEmpty","tagname":"method","owner":"sol.common.forms.Utils","id":"method-isColumnEmpty","meta":{}},{"name":"isFieldChanged","tagname":"method","owner":"sol.common.forms.Utils","id":"method-isFieldChanged","meta":{}},{"name":"isFieldChangedOrFormLoaded","tagname":"method","owner":"sol.common.forms.Utils","id":"method-isFieldChangedOrFormLoaded","meta":{}},{"name":"navigateTable","tagname":"method","owner":"sol.common.forms.Utils","id":"method-navigateTable","meta":{"private":true}},{"name":"normalizeDecimal","tagname":"method","owner":"sol.common.forms.Utils","id":"method-normalizeDecimal","meta":{}},{"name":"parseDecimal","tagname":"method","owner":"sol.common.forms.Utils","id":"method-parseDecimal","meta":{}},{"name":"registerResetNewLineFunction","tagname":"method","owner":"sol.common.forms.Utils","id":"method-registerResetNewLineFunction","meta":{}},{"name":"registerTableNavigation","tagname":"method","owner":"sol.common.forms.Utils","id":"method-registerTableNavigation","meta":{}},{"name":"registerUpdate","tagname":"method","owner":"sol.common.forms.Utils","id":"method-registerUpdate","meta":{}},{"name":"removeBodyClass","tagname":"method","owner":"sol.common.forms.Utils","id":"method-removeBodyClass","meta":{}},{"name":"removeFieldNamePrefix","tagname":"method","owner":"sol.common.forms.Utils","id":"method-removeFieldNamePrefix","meta":{}},{"name":"removeHiddenCheckboxes","tagname":"method","owner":"sol.common.forms.Utils","id":"method-removeHiddenCheckboxes","meta":{}},{"name":"removeTables","tagname":"method","owner":"sol.common.forms.Utils","id":"method-removeTables","meta":{}},{"name":"resetFormLayout","tagname":"method","owner":"sol.common.forms.Utils","id":"method-resetFormLayout","meta":{}},{"name":"resetNewLine","tagname":"method","owner":"sol.common.forms.Utils","id":"method-resetNewLine","meta":{}},{"name":"scrollToTop","tagname":"method","owner":"sol.common.forms.Utils","id":"method-scrollToTop","meta":{}},{"name":"sendPost","tagname":"method","owner":"sol.common.forms.Utils","id":"method-sendPost","meta":{}},{"name":"setActionMode","tagname":"method","owner":"sol.common.forms.Utils","id":"method-setActionMode","meta":{}},{"name":"setDefaultValue","tagname":"method","owner":"sol.common.forms.Utils","id":"method-setDefaultValue","meta":{}},{"name":"setHiddenValue","tagname":"method","owner":"sol.common.forms.Utils","id":"method-setHiddenValue","meta":{}},{"name":"setIsoDate","tagname":"method","owner":"sol.common.forms.Utils","id":"method-setIsoDate","meta":{}},{"name":"setMainHeader","tagname":"method","owner":"sol.common.forms.Utils","id":"method-setMainHeader","meta":{}},{"name":"setResponsive","tagname":"method","owner":"sol.common.forms.Utils","id":"method-setResponsive","meta":{}},{"name":"setSuccessor","tagname":"method","owner":"sol.common.forms.Utils","id":"method-setSuccessor","meta":{}},{"name":"showColumn","tagname":"method","owner":"sol.common.forms.Utils","id":"method-showColumn","meta":{}},{"name":"showColumns","tagname":"method","owner":"sol.common.forms.Utils","id":"method-showColumns","meta":{}},{"name":"showRows","tagname":"method","owner":"sol.common.forms.Utils","id":"method-showRows","meta":{}},{"name":"showTemplate","tagname":"method","owner":"sol.common.forms.Utils","id":"method-showTemplate","meta":{}},{"name":"showTemplateListWarning","tagname":"method","owner":"sol.common.forms.Utils","id":"method-showTemplateListWarning","meta":{}},{"name":"sumItems","tagname":"method","owner":"sol.common.forms.Utils","id":"method-sumItems","meta":{}},{"name":"toDecimal","tagname":"method","owner":"sol.common.forms.Utils","id":"method-toDecimal","meta":{}},{"name":"updateDecimal","tagname":"method","owner":"sol.common.forms.Utils","id":"method-updateDecimal","meta":{}},{"name":"updateValues","tagname":"method","owner":"sol.common.forms.Utils","id":"method-updateValues","meta":{}},{"name":"writeDecimalField","tagname":"method","owner":"sol.common.forms.Utils","id":"method-writeDecimalField","meta":{"private":true}},{"name":"writeUpdates","tagname":"method","owner":"sol.common.forms.Utils","id":"method-writeUpdates","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.forms.Utils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.forms.Utils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils' target='_blank'>lib_sol.common.forms.Utils.js</a></div></pre><div class='doc-contents'><p>Helper functions for ELOwf forms</p>\n      <p class='version-tag'>Version: <b>1.03.006</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-keyCodeArrowDown' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-property-keyCodeArrowDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-property-keyCodeArrowDown' class='name expandable'>keyCodeArrowDown</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>40</code></p></div></div></div><div id='property-keyCodeArrowLeft' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-property-keyCodeArrowLeft' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-property-keyCodeArrowLeft' class='name expandable'>keyCodeArrowLeft</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>37</code></p></div></div></div><div id='property-keyCodeArrowRight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-property-keyCodeArrowRight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-property-keyCodeArrowRight' class='name expandable'>keyCodeArrowRight</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>39</code></p></div></div></div><div id='property-keyCodeArrowUp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-property-keyCodeArrowUp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-property-keyCodeArrowUp' class='name expandable'>keyCodeArrowUp</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>38</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-unitSuffix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-property-unitSuffix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-property-unitSuffix' class='name expandable'>unitSuffix</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;_UNIT&quot;</code></p></div></div></div><div id='property-wfMapSavedFlag' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-property-wfMapSavedFlag' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-property-wfMapSavedFlag' class='name expandable'>wfMapSavedFlag</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;WF_MAP_FORM_SAVED&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-MultiIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-MultiIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-MultiIndex' class='name expandable'>MultiIndex</a>( <span class='pre'>f</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates an easily editable field from a multiindex field value. ...</div><div class='long'><p>Creates an easily editable field from a multiindex field value.\ne.g. mi = MultiIndex(\"abc¶def¶xyz\");\n     mi.values() => [\"abc\", \"def\", \"xyz\"]\n     mi.add(\"test\") => [\"abc\", \"def\", \"xyz\", \"test\"]\n     mi.remove(\"def\") => [\"abc\", \"xyz\", \"test\"]\n     mi.contains(\"abc\") => true\n     String(mi) => \"abc¶xyz¶test\"\n     mi.save(\"IX_GRP_MYFIELD\") => $updates MYFIELD with current String representation</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>f</span> : String|FormWrapper Field<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>MultiIndex field</p>\n</div></li></ul></div></div></div><div id='method-addBodyClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-addBodyClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-addBodyClass' class='name expandable'>addBodyClass</a>( <span class='pre'>className</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds a class to the ´body´ tag ...</div><div class='long'><p>Adds a class to the ´body´ tag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addClickListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-addClickListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-addClickListener' class='name expandable'>addClickListener</a>( <span class='pre'>params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Registers a click handler ...</div><div class='long'><p>Registers a click handler</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>Button name</p>\n</div></li><li><span class='pre'>prefix</span> : String<div class='sub-desc'><p>Button name prefix</p>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'><p>Context</p>\n</div></li><li><span class='pre'>func</span> : Function<div class='sub-desc'><p>Function</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-addJsAddLineButtonListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-addJsAddLineButtonListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-addJsAddLineButtonListener' class='name expandable'>addJsAddLineButtonListener</a>( <span class='pre'>fieldName, func</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds a listener to an JsAddLineButton ...</div><div class='long'><p>Adds a listener to an JsAddLineButton</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name within the JS add line table</p>\n</div></li><li><span class='pre'>func</span> : Function<div class='sub-desc'><p>Function</p>\n</div></li></ul></div></div></div><div id='method-addListener' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>event, fieldKey, ctx, func</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds a callback function to the event listener of an input field. ...</div><div class='long'><p>Adds a callback function to the event listener of an input field.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>event</span> : string<div class='sub-desc'><p>Name of the event.</p>\n</div></li><li><span class='pre'>fieldKey</span> : string<div class='sub-desc'><p>Field key of the input field.</p>\n</div></li><li><span class='pre'>ctx</span> : object<div class='sub-desc'><p>Exteution context.</p>\n</div></li><li><span class='pre'>func</span> : function<div class='sub-desc'><p>Callback function.</p>\n</div></li></ul></div></div></div><div id='method-applyUserImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-applyUserImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-applyUserImage' class='name expandable'>applyUserImage</a>( <span class='pre'>userNameMap, userIdMap</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Renders a user image ...</div><div class='long'><p>Renders a user image</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userNameMap</span> : String<div class='sub-desc'><p>Name of the map field that contains the username</p>\n</div></li><li><span class='pre'>userIdMap</span> : String<div class='sub-desc'><p>Name of the field that contains the user id</p>\n</div></li></ul></div></div></div><div id='method-applyUserImages' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-applyUserImages' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-applyUserImages' class='name expandable'>applyUserImages</a>( <span class='pre'>userNameMap, userIdMap</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Renders images for a given user set. ...</div><div class='long'><p>Renders images for a given user set. Internally calls applyUserImage on each entry of the map.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userNameMap</span> : String<div class='sub-desc'><p>Name of the map field that contains the username</p>\n</div></li><li><span class='pre'>userIdMap</span> : String<div class='sub-desc'><p>Name of the field that contains the user id</p>\n</div></li></ul></div></div></div><div id='method-callInputChangedForDynKwlChanges' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-callInputChangedForDynKwlChanges' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-callInputChangedForDynKwlChanges' class='name expandable'>callInputChangedForDynKwlChanges</a>( <span class='pre'>dynListItem</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Calls the function inputChanged for fields changed by a dynamic keyword list ...</div><div class='long'><p>Calls the function <code>inputChanged</code> for fields changed by a dynamic keyword list</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dynListItem</span> : Object<div class='sub-desc'><p>Dynamic keyword list item</p>\n</div></li></ul></div></div></div><div id='method-callRegisteredFunction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-callRegisteredFunction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-callRegisteredFunction' class='name expandable'>callRegisteredFunction</a>( <span class='pre'>fctName, paramObj, success, failure</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Calls the registered function of the given name. ...</div><div class='long'><p>Calls the registered function of the given name.\nAs parameter a JSON object can be given.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fctName</span> : String<div class='sub-desc'><p>The name of the registered function to call.</p>\n</div></li><li><span class='pre'>paramObj</span> : Object<div class='sub-desc'><p>The input data for the function, sent as Serialized String value of the Any object.</p>\n</div></li><li><span class='pre'>success</span> : Function<div class='sub-desc'><p>Success callback function. The argument value\n is the deserialized JSON object from the String value of the Any\n object that was returned from the registered function.</p>\n</div></li><li><span class='pre'>failure</span> : Function<div class='sub-desc'><p>Failure callback function the error object will be given as parameter.</p>\n</div></li></ul></div></div></div><div id='method-checkMandatoryFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-checkMandatoryFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-checkMandatoryFields' class='name expandable'>checkMandatoryFields</a>( <span class='pre'>fieldNames</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Check wether mandatory fields exist ...</div><div class='long'><p>Check wether mandatory fields exist</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldNames</span> : Array<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkSource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-checkSource' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-checkSource' class='name expandable'>checkSource</a>( <span class='pre'>source</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the changed input field es set ...</div><div class='long'><p>Checks if the changed input field es set</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>Changed input field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-checkVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-checkVersion' class='name expandable'>checkVersion</a>( <span class='pre'>currentVersionString, requiredVersionString</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks the version of ELO components ...</div><div class='long'><p>Checks the version of ELO components</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>currentVersionString</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>requiredVersionString</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Return true if the current version is equal or higher then the required version</p>\n</div></li></ul></div></div></div><div id='method-clearRemainingLines' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-clearRemainingLines' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-clearRemainingLines' class='name expandable'>clearRemainingLines</a>( <span class='pre'>fieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Clears remaining lines ...</div><div class='long'><p>Clears remaining lines</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul></div></div></div><div id='method-columnExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-columnExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-columnExists' class='name expandable'>columnExists</a>( <span class='pre'>columnName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks whether a column exists ...</div><div class='long'><p>Checks whether a column exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'><p>Column name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-copyIsoDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-copyIsoDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-copyIsoDate' class='name expandable'>copyIsoDate</a>( <span class='pre'>srcFieldName, dstFieldName, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Copies an ISO date ...</div><div class='long'><p>Copies an ISO date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcFieldName</span> : String<div class='sub-desc'><p>Source field name</p>\n</div></li><li><span class='pre'>dstFieldName</span> : String<div class='sub-desc'><p>Destination field name</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>callInputChanged</span> : Boolean<div class='sub-desc'><p>If true the function ´inputChanged´ will be called</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-countLines' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-countLines' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-countLines' class='name expandable'>countLines</a>( <span class='pre'>indicatorColumnName</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the number of lines ...</div><div class='long'><p>Returns the number of lines</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>indicatorColumnName</span> : String<div class='sub-desc'><p>Indicator column name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>Number of lines</p>\n</div></li></ul></div></div></div><div id='method-disableCancelButtonValidation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-disableCancelButtonValidation' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-disableCancelButtonValidation' class='name expandable'>disableCancelButtonValidation</a>( <span class='pre'>successorNodeId, cancelButtonTranslationKeys</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Disables the validation if cancel button is pressed\n\nExample:\n\nfunction nextClicked(id) {\n  sol.common.forms.Utils.di...</div><div class='long'><p>Disables the validation if cancel button is pressed</p>\n\n<h3>Example:</h3>\n\n<pre><code>function nextClicked(id) {\n  <a href=\"#!/api/sol.common.forms.Utils-method-disableCancelButtonValidation\" rel=\"sol.common.forms.Utils-method-disableCancelButtonValidation\" class=\"docClass\">sol.common.forms.Utils.disableCancelButtonValidation</a>(id, [\"sol.common.wf.node.cancel\"]);\n  return true;\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>successorNodeId</span> : String<div class='sub-desc'><p>Node ID of the successor node</p>\n</div></li><li><span class='pre'>cancelButtonTranslationKeys</span> : Array<div class='sub-desc'><p>Cancel button translation key</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-disableColumn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-disableColumn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-disableColumn' class='name expandable'>disableColumn</a>( <span class='pre'>columnName, disable, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Disable column ...</div><div class='long'><p>Disable column</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'><p>Column name</p>\n</div></li><li><span class='pre'>disable</span> : Boolean<div class='sub-desc'><p>If true then the field will be disabled</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>clear</span> : Boolean<div class='sub-desc'><p>Clear value</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-disableDependentFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-disableDependentFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-disableDependentFields' class='name expandable'>disableDependentFields</a>( <span class='pre'>disableDependentFieldsConfig, changedInput</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Disables dependent fields ...</div><div class='long'><p>Disables dependent fields</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disableDependentFieldsConfig</span> : Object<div class='sub-desc'><p>Configuration to disable dependent fields</p>\n</div></li><li><span class='pre'>changedInput</span> : Object<div class='sub-desc'><p>Changed input field</p>\n</div></li></ul></div></div></div><div id='method-disableField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-disableField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-disableField' class='name expandable'>disableField</a>( <span class='pre'>fieldName, disable, params</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Disables a field ...</div><div class='long'><p>Disables a field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li><li><span class='pre'>disable</span> : Boolean<div class='sub-desc'><p>If true then the field will be disabled</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Field is changed</p>\n</div></li></ul></div></div></div><div id='method-disableFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-disableFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-disableFields' class='name expandable'>disableFields</a>( <span class='pre'>fieldNames, index, disable, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Disable fields ...</div><div class='long'><p>Disable fields</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldNames</span> : Array<div class='sub-desc'><p>Field names</p>\n</div></li><li><span class='pre'>index</span> : Number<div class='sub-desc'><p>Index</p>\n</div></li><li><span class='pre'>disable</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-disableForwardButtons' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-disableForwardButtons' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-disableForwardButtons' class='name expandable'>disableForwardButtons</a>( <span class='pre'>[disable]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Enables or disables forward buttons ...</div><div class='long'><p>Enables or disables forward buttons</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disable</span> : Boolean (optional)<div class='sub-desc'><p>Disable button</p>\n<p>Defaults to: <code>true</code></p></div></li></ul></div></div></div><div id='method-disableRowsByIndicatorField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-disableRowsByIndicatorField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-disableRowsByIndicatorField' class='name expandable'>disableRowsByIndicatorField</a>( <span class='pre'>indicatorColumnName, func</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets rows read-only ...</div><div class='long'><p>Sets rows read-only</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>indicatorColumnName</span> : String<div class='sub-desc'><p>Read-only indicator field</p>\n</div></li><li><span class='pre'>func</span> : Function<div class='sub-desc'><p>Function that must return a boolean to determinate whether the row should be disabled</p>\n</div></li></ul></div></div></div><div id='method-enableRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-enableRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-enableRow' class='name expandable'>enableRow</a>( <span class='pre'>indicatorElement, enable</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Enables/disables a row ...</div><div class='long'><p>Enables/disables a row</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>indicatorElement</span> : type<div class='sub-desc'>\n</div></li><li><span class='pre'>enable</span> : type<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-encodeParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-encodeParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-encodeParams' class='name expandable'>encodeParams</a>( <span class='pre'>params, separator</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Encodes parameters ...</div><div class='long'><p>Encodes parameters</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n</div></li><li><span class='pre'>separator</span> : String<div class='sub-desc'><p>Separator</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-ensureRowExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-ensureRowExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-ensureRowExists' class='name expandable'>ensureRowExists</a>( <span class='pre'>fieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Ensures that a specific table row exists ...</div><div class='long'><p>Ensures that a specific table row exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul></div></div></div><div id='method-fieldExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-fieldExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-fieldExists' class='name expandable'>fieldExists</a>( <span class='pre'>fieldName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a field exists ...</div><div class='long'><p>Checks wether a field exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-forEachRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-forEachRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-forEachRow' class='name expandable'>forEachRow</a>( <span class='pre'>endOfTableIndicatorColumnName, func, ctx</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Iterates over a table. ...</div><div class='long'><p>Iterates over a table.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>endOfTableIndicatorColumnName</span> : String<div class='sub-desc'><p>Name of a column to check if the line exists.</p>\n</div></li><li><span class='pre'>func</span> : Function<div class='sub-desc'><p>Callback function for the iteration.</p>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'><p>Execution context.</p>\n</div></li></ul></div></div></div><div id='method-getAddLineButton' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getAddLineButton' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getAddLineButton' class='name expandable'>getAddLineButton</a>( <span class='pre'>fieldName</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Finds a JS_ADDLINE button by a given field name ...</div><div class='long'><p>Finds a JS_ADDLINE button by a given field name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getAppApiUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getAppApiUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getAppApiUrl' class='name expandable'>getAppApiUrl</a>( <span class='pre'>appName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the URL for an app API ...</div><div class='long'><p>Returns the URL for an app API</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>appName</span> : String<div class='sub-desc'><p>App name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ELOapp API URL</p>\n</div></li></ul></div></div></div><div id='method-getAppUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getAppUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getAppUrl' class='name expandable'>getAppUrl</a>( <span class='pre'>appName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the URL for a specific app ...</div><div class='long'><p>Returns the URL for a specific app</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>appName</span> : String<div class='sub-desc'><p>App name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ELOapp URL</p>\n</div></li></ul></div></div></div><div id='method-getAsBaseUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getAsBaseUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getAsBaseUrl' class='name expandable'>getAsBaseUrl</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the ELOas base URL ...</div><div class='long'><p>Returns the ELOas base URL</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ELOas base URL</p>\n</div></li></ul></div></div></div><div id='method-getBaseFieldName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getBaseFieldName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getBaseFieldName' class='name expandable'>getBaseFieldName</a>( <span class='pre'>source</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the field name without unit suffix and trailing numbers ...</div><div class='long'><p>Returns the field name without unit suffix and trailing numbers</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object|String<div class='sub-desc'><p>Source element or field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCell' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getCell' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getCell' class='name expandable'>getCell</a>( <span class='pre'>element</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the surrounding cell ...</div><div class='long'><p>Returns the surrounding cell</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'><p>HTML element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getColumnIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getColumnIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getColumnIndex' class='name expandable'>getColumnIndex</a>( <span class='pre'>field</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the column index ...</div><div class='long'><p>Returns the column index</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>Column index</p>\n</div></li></ul></div></div></div><div id='method-getDisplayDecimalPlaces' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getDisplayDecimalPlaces' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getDisplayDecimalPlaces' class='name expandable'>getDisplayDecimalPlaces</a>( <span class='pre'>field</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Return display decimal decimalPlaces ...</div><div class='long'><p>Return display decimal decimalPlaces</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getElementsInRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getElementsInRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getElementsInRow' class='name expandable'>getElementsInRow</a>( <span class='pre'>element</span> ) : NodeList<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the input fields and buttons in the row ...</div><div class='long'><p>Returns the input fields and buttons in the row</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>NodeList</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFieldNameIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getFieldNameIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getFieldNameIndex' class='name expandable'>getFieldNameIndex</a>( <span class='pre'>fieldName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the field index ...</div><div class='long'><p>Returns the field index</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFieldNamePrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getFieldNamePrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getFieldNamePrefix' class='name expandable'>getFieldNamePrefix</a>( <span class='pre'>source, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the field name without trailing numbers ...</div><div class='long'><p>Returns the field name without trailing numbers</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object|String<div class='sub-desc'><p>Source element or field name</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>replaceNumberBy</span> : String (optional)<div class='sub-desc'><p>Replace the number by this string</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFormLanguage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getFormLanguage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getFormLanguage' class='name expandable'>getFormLanguage</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the language of the form ...</div><div class='long'><p>Returns the language of the form</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Language</p>\n</div></li></ul></div></div></div><div id='method-getForwardButton' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getForwardButton' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getForwardButton' class='name expandable'>getForwardButton</a>( <span class='pre'>params</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a next button ...</div><div class='long'><p>Returns a next button</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>nextNodeTranslationKey</span> : String<div class='sub-desc'><p>Translation key of the next node</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>Forward button</p>\n</div></li></ul></div></div></div><div id='method-getForwardButtons' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getForwardButtons' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getForwardButtons' class='name expandable'>getForwardButtons</a>( <span class='pre'></span> ) : NodeList<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns forward buttons ...</div><div class='long'><p>Returns forward buttons</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>NodeList</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getInputDataType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getInputDataType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getInputDataType' class='name expandable'>getInputDataType</a>( <span class='pre'>input</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the input type ...</div><div class='long'><p>Returns the input type</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>input</span> : HTMLElement<div class='sub-desc'><p>Input</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Data type</p>\n</div></li></ul></div></div></div><div id='method-getInputsInRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getInputsInRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getInputsInRow' class='name expandable'>getInputsInRow</a>( <span class='pre'>element</span> ) : NodeList<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the input fields in the row ...</div><div class='long'><p>Returns the input fields in the row</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>NodeList</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getIsoDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getIsoDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getIsoDate' class='name expandable'>getIsoDate</a>( <span class='pre'>fieldName, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns an ISO formatted date ...</div><div class='long'><p>Returns an ISO formatted date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>startOfDay</span> : Boolean<div class='sub-desc'><p>Start of day</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getJsAddLineButton' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getJsAddLineButton' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getJsAddLineButton' class='name expandable'>getJsAddLineButton</a>( <span class='pre'>field</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the \"JS add line\" button ...</div><div class='long'><p>Returns the \"JS add line\" button</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : String|HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getJsAddLineButtonById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getJsAddLineButtonById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getJsAddLineButtonById' class='name expandable'>getJsAddLineButtonById</a>( <span class='pre'>addLineId</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the \"JS add line\" button ...</div><div class='long'><p>Returns the \"JS add line\" button</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>addLineId</span> : String<div class='sub-desc'><p>Add line ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getJsAddLineRowById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getJsAddLineRowById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getJsAddLineRowById' class='name expandable'>getJsAddLineRowById</a>( <span class='pre'>addLineId, lineNo</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the JS add line row by ID ...</div><div class='long'><p>Returns the JS add line row by ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>addLineId</span> : String<div class='sub-desc'><p>Add line ID</p>\n</div></li><li><span class='pre'>lineNo</span> : String<div class='sub-desc'><p>Line number</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>row</p>\n</div></li></ul></div></div></div><div id='method-getLastInput' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getLastInput' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getLastInput' class='name expandable'>getLastInput</a>( <span class='pre'>columnName</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Return the last input field in the table ...</div><div class='long'><p>Return the last input field in the table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLocation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getLocation' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getLocation' class='name expandable'>getLocation</a>( <span class='pre'>url</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Gets the location info from a given URL ...</div><div class='long'><p>Gets the location info from a given URL</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>urlParts</p>\n</div></li></ul></div></div></div><div id='method-getNextButtonIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getNextButtonIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getNextButtonIndex' class='name expandable'>getNextButtonIndex</a>( <span class='pre'>successorNodeId</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the index of the next button ...</div><div class='long'><p>Returns the index of the next button</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>successorNodeId</span> : String<div class='sub-desc'><p>Node ID of the successor node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>Index of the next button</p>\n</div></li></ul></div></div></div><div id='method-getNextButtonTranslationKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getNextButtonTranslationKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getNextButtonTranslationKey' class='name expandable'>getNextButtonTranslationKey</a>( <span class='pre'>nodeId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the translation key of the next button by a given nodeId ...</div><div class='long'><p>Returns the translation key of the next button by a given nodeId</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nodeId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Translation key</p>\n</div></li></ul></div></div></div><div id='method-getNextHorizontalField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getNextHorizontalField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getNextHorizontalField' class='name expandable'>getNextHorizontalField</a>( <span class='pre'>field, columnCount</span> ) : HTMLElement<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns the next horizontal field ...</div><div class='long'><p>Returns the next horizontal field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li><li><span class='pre'>columnCount</span> : HTMLElement<div class='sub-desc'><p>Column count</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>Next horizontal input field</p>\n</div></li></ul></div></div></div><div id='method-getNextVerticalField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getNextVerticalField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getNextVerticalField' class='name expandable'>getNextVerticalField</a>( <span class='pre'>baseFieldName, fieldNameIndex, rowCount</span> ) : HTMLElement<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Return the next vertical input field ...</div><div class='long'><p>Return the next vertical input field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>baseFieldName</span> : String<div class='sub-desc'><p>Base field name</p>\n</div></li><li><span class='pre'>fieldNameIndex</span> : String<div class='sub-desc'><p>Field name index</p>\n</div></li><li><span class='pre'>rowCount</span> : String<div class='sub-desc'><p>Row count</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>Next vertical input field</p>\n</div></li></ul></div></div></div><div id='method-getNextWriteableHorizontalField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getNextWriteableHorizontalField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getNextWriteableHorizontalField' class='name expandable'>getNextWriteableHorizontalField</a>( <span class='pre'>field, columnCount</span> ) : HTMLElement<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Returns the next writeable horizontal field ...</div><div class='long'><p>Returns the next writeable horizontal field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li><li><span class='pre'>columnCount</span> : HTMLElement<div class='sub-desc'><p>Column count</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>Next horizontal input field</p>\n</div></li></ul></div></div></div><div id='method-getNextWriteableVerticalField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getNextWriteableVerticalField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getNextWriteableVerticalField' class='name expandable'>getNextWriteableVerticalField</a>( <span class='pre'>baseFieldName, fieldNameIndex, rowCount</span> ) : HTMLElement<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Return the next writeable vertical input field ...</div><div class='long'><p>Return the next writeable vertical input field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>baseFieldName</span> : String<div class='sub-desc'><p>Base field name</p>\n</div></li><li><span class='pre'>fieldNameIndex</span> : String<div class='sub-desc'><p>Field name index</p>\n</div></li><li><span class='pre'>rowCount</span> : String<div class='sub-desc'><p>Row count</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>Next vertical input field</p>\n</div></li></ul></div></div></div><div id='method-getParentByTagName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getParentByTagName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getParentByTagName' class='name expandable'>getParentByTagName</a>( <span class='pre'>element, tagName</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a parent element by a given tag name\ne.g. ...</div><div class='long'><p>Returns a parent element by a given tag name\ne.g. to find the surrounding table of an element</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'><p>HTML element.</p>\n</div></li><li><span class='pre'>tagName</span> : String<div class='sub-desc'><p>Tag name of the wanted element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getParentTable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getParentTable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getParentTable' class='name expandable'>getParentTable</a>( <span class='pre'>element</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the parent table ...</div><div class='long'><p>Returns the parent table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'><p>Element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'><p>Table</p>\n</div></li></ul></div></div></div><div id='method-getRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getRow' class='name expandable'>getRow</a>( <span class='pre'>element</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the surrounding row ...</div><div class='long'><p>Returns the surrounding row</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'><p>HTML element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRowIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getRowIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getRowIndex' class='name expandable'>getRowIndex</a>( <span class='pre'>field</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the index number of the row ...</div><div class='long'><p>Returns the index number of the row</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Row index</p>\n</div></li></ul></div></div></div><div id='method-getTable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getTable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getTable' class='name expandable'>getTable</a>( <span class='pre'>element</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the surrounding table ...</div><div class='long'><p>Returns the surrounding table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'><p>HTML element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getTemplate' class='name expandable'>getTemplate</a>( <span class='pre'>element</span> ) : HTMLElement<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the template ...</div><div class='long'><p>Returns the template</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : HTMLElement<div class='sub-desc'><p>HTML element</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplateSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getTemplateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getTemplateSord' class='name expandable'>getTemplateSord</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a template Sord ...</div><div class='long'><p>Returns a template Sord</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Template sord</p>\n</div></li></ul></div></div></div><div id='method-getUserImageUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getUserImageUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getUserImageUrl' class='name expandable'>getUserImageUrl</a>( <span class='pre'>username, userid</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>generates a user image url relative to the current form. ...</div><div class='long'><p>generates a user image url relative to the current form.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>username</span> : String<div class='sub-desc'><p>ELO Username</p>\n</div></li><li><span class='pre'>userid</span> : String<div class='sub-desc'><p>ELO User id</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getWfUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-getWfUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-getWfUrl' class='name expandable'>getWfUrl</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the ELOwf URL ...</div><div class='long'><p>Returns the ELOwf URL</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>ELOwf URL</p>\n</div></li></ul></div></div></div><div id='method-gotoSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-gotoSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-gotoSord' class='name expandable'>gotoSord</a>( <span class='pre'>guid</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Goto a sord ...</div><div class='long'><p>Goto a sord</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>guid</span> : String<div class='sub-desc'><p>GUID</p>\n</div></li></ul></div></div></div><div id='method-hideTabBarIfOnlyOneTab' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-hideTabBarIfOnlyOneTab' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-hideTabBarIfOnlyOneTab' class='name expandable'>hideTabBarIfOnlyOneTab</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Hides the tab bar if only one tab was added to the form. ...</div><div class='long'><p>Hides the tab bar if only one tab was added to the form.</p>\n</div></div></div><div id='method-hideTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-hideTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-hideTemplate' class='name expandable'>hideTemplate</a>( <span class='pre'>field</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Hides a template ...</div><div class='long'><p>Hides a template</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-initializeForm' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-initializeForm' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-initializeForm' class='name expandable'>initializeForm</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initializing actions after loading the form. ...</div><div class='long'><p>Initializing actions after loading the form.</p>\n</div></div></div><div id='method-initializeIxSession' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-initializeIxSession' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-initializeIxSession' class='name expandable'>initializeIxSession</a>( <span class='pre'>successCallback, failureCallback, absoluteUrl</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initializes an index server connection and sets both elo.IX and elo.CONST. ...</div><div class='long'><p>Initializes an index server connection and sets both elo.IX and elo.CONST.</p>\n\n<p>By default the relative url is used. If this url is not accesible for some reason the internal absolute url is tried instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>successCallback</span> : Function<div class='sub-desc'>\n</div></li><li><span class='pre'>failureCallback</span> : Function<div class='sub-desc'>\n</div></li><li><span class='pre'>absoluteUrl</span> : boolean<div class='sub-desc'><p>defines wheather to use an absolute url or not. Defaults to false.</p>\n</div></li></ul></div></div></div><div id='method-isArrowKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-isArrowKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-isArrowKey' class='name expandable'>isArrowKey</a>( <span class='pre'>keyCode</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks whether the pressed key is an arrow key ...</div><div class='long'><p>Checks whether the pressed key is an arrow key</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>keyCode</span> : Number<div class='sub-desc'><p>Key code;</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isColumnEmpty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-isColumnEmpty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-isColumnEmpty' class='name expandable'>isColumnEmpty</a>( <span class='pre'>columnName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the column is empty ...</div><div class='long'><p>Returns true if the column is empty</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'><p>Column name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFieldChanged' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-isFieldChanged' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-isFieldChanged' class='name expandable'>isFieldChanged</a>( <span class='pre'>source, fieldNames</span> ) : undefined<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the specific field has been changed ...</div><div class='long'><p>Checks if the specific field has been changed</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>Changed HTML element.</p>\n</div></li><li><span class='pre'>fieldNames</span> : Array<div class='sub-desc'><p>Array of field names.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>undefined</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFieldChangedOrFormLoaded' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-isFieldChangedOrFormLoaded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-isFieldChangedOrFormLoaded' class='name expandable'>isFieldChangedOrFormLoaded</a>( <span class='pre'>source, fieldNames</span> ) : undefined<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the specific field has been changed or the form is loaded ...</div><div class='long'><p>Checks if the specific field has been changed or the form is loaded</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>Changed HTML element.</p>\n</div></li><li><span class='pre'>fieldNames</span> : Array<div class='sub-desc'><p>Array of field names.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>undefined</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-navigateTable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-navigateTable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-navigateTable' class='name expandable'>navigateTable</a>( <span class='pre'>event</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>event</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-normalizeDecimal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-normalizeDecimal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-normalizeDecimal' class='name expandable'>normalizeDecimal</a>( <span class='pre'>field, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Normalize decimals ...</div><div class='long'><p>Normalize decimals</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Params</p>\n</div></li></ul></div></div></div><div id='method-parseDecimal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-parseDecimal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-parseDecimal' class='name expandable'>parseDecimal</a>( <span class='pre'>str</span> ) : Decimal<span class=\"signature\"></span></div><div class='description'><div class='short'>Parse to Decimal ...</div><div class='long'><p>Parse to Decimal</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Number as String</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Decimal</span><div class='sub-desc'><p>Decimal</p>\n</div></li></ul></div></div></div><div id='method-registerResetNewLineFunction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-registerResetNewLineFunction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-registerResetNewLineFunction' class='name expandable'>registerResetNewLineFunction</a>( <span class='pre'>columnName, notEmpty</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Registers an click handler to clear a new line ...</div><div class='long'><p>Registers an click handler to clear a new line</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'><p>Column name</p>\n</div></li><li><span class='pre'>notEmpty</span> : String<div class='sub-desc'><p>Previous line must not be empty</p>\n</div></li></ul></div></div></div><div id='method-registerTableNavigation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-registerTableNavigation' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-registerTableNavigation' class='name expandable'>registerTableNavigation</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Register table navigation ...</div><div class='long'><p>Register table navigation</p>\n</div></div></div><div id='method-registerUpdate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-registerUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-registerUpdate' class='name expandable'>registerUpdate</a>( <span class='pre'>ruleName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Registers an element for update. ...</div><div class='long'><p>Registers an element for update.</p>\n\n<p>To do so, it calls the rule defined by <code>ruleName</code> with the wf objects objId (as <code>param1</code>).</p>\n\n<p>Update will only be registered, if the page has changed.\nThis only applies if the form was initialized using <a href=\"#!/api/sol.common.forms.Utils-method-initializeForm\" rel=\"sol.common.forms.Utils-method-initializeForm\" class=\"docClass\">initializeForm</a>.\nIf not, the update will always be executed.</p>\n        <p>Available since: <b>1.05.000 this can be called without a `ruleName` to register the element for direct update (without using the job queue). The common_monitoring package hast to be installed.</b></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ruleName</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeBodyClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-removeBodyClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-removeBodyClass' class='name expandable'>removeBodyClass</a>( <span class='pre'>className</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes a class from the ´body´ tag ...</div><div class='long'><p>Removes a class from the ´body´ tag</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeFieldNamePrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-removeFieldNamePrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-removeFieldNamePrefix' class='name expandable'>removeFieldNamePrefix</a>( <span class='pre'>fieldName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes the field name prefix ...</div><div class='long'><p>Removes the field name prefix</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Field name without prefix</p>\n</div></li></ul></div></div></div><div id='method-removeHiddenCheckboxes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-removeHiddenCheckboxes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-removeHiddenCheckboxes' class='name expandable'>removeHiddenCheckboxes</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Remove all checkboxes within the form to avoid validation ...</div><div class='long'><p>Remove all checkboxes within the form to avoid validation</p>\n</div></div></div><div id='method-removeTables' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-removeTables' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-removeTables' class='name expandable'>removeTables</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Remove all tables within the form to avoid validation ...</div><div class='long'><p>Remove all tables within the form to avoid validation</p>\n</div></div></div><div id='method-resetFormLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-resetFormLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-resetFormLayout' class='name expandable'>resetFormLayout</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Reset form layout if page content changes. ...</div><div class='long'><p>Reset form layout if page content changes.</p>\n</div></div></div><div id='method-resetNewLine' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-resetNewLine' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-resetNewLine' class='name expandable'>resetNewLine</a>( <span class='pre'>columnName, notEmpty</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Resets all input fields of a new line ...</div><div class='long'><p>Resets all input fields of a new line</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'><p>Column name</p>\n</div></li><li><span class='pre'>notEmpty</span> : String<div class='sub-desc'><p>Previous line must not be empty</p>\n</div></li></ul></div></div></div><div id='method-scrollToTop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-scrollToTop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-scrollToTop' class='name expandable'>scrollToTop</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Scroll to top of the page. ...</div><div class='long'><p>Scroll to top of the page.</p>\n</div></div></div><div id='method-sendPost' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-sendPost' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-sendPost' class='name expandable'>sendPost</a>( <span class='pre'>url, dataObj, success, failure, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sends a post request ...</div><div class='long'><p>Sends a post request</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li><li><span class='pre'>dataObj</span> : Object<div class='sub-desc'><p>Data object</p>\n</div></li><li><span class='pre'>success</span> : Function<div class='sub-desc'><p>Success callback function.</p>\n</div></li><li><span class='pre'>failure</span> : Function<div class='sub-desc'><p>Failure callback function the error object will be given as parameter.</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>reqParamsObj</span> : Object<div class='sub-desc'><p>Request params object</p>\n</div></li><li><span class='pre'>addTicket</span> : Boolean<div class='sub-desc'><p>Add ticket</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-setActionMode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-setActionMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-setActionMode' class='name expandable'>setActionMode</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Set CSS Classes . ...</div><div class='long'><p>Set CSS Classes .</p>\n</div></div></div><div id='method-setDefaultValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-setDefaultValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-setDefaultValue' class='name expandable'>setDefaultValue</a>( <span class='pre'>fieldName, defaultValue</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a default value if it's empty ...</div><div class='long'><p>Sets a default value if it's empty</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li><li><span class='pre'>defaultValue</span> : String<div class='sub-desc'><p>Default value</p>\n</div></li></ul></div></div></div><div id='method-setHiddenValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-setHiddenValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-setHiddenValue' class='name expandable'>setHiddenValue</a>( <span class='pre'>cfg, value</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This creates a hidden field to write values to the sord. ...</div><div class='long'><p>This creates a hidden field to write values to the sord.\nIf a field already exists the existing field will be updated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>type</span> : String (optional)<div class='sub-desc'><p>GRP|MAP|WFMAP</p>\n<p>Defaults to: <code>GRP</code></p></div></li><li><span class='pre'>key</span> : String<div class='sub-desc'>\n</div></li></ul></div></li><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setIsoDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-setIsoDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-setIsoDate' class='name expandable'>setIsoDate</a>( <span class='pre'>fieldName, isoDate, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets an ISO date ...</div><div class='long'><p>Sets an ISO date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li><li><span class='pre'>isoDate</span> : String<div class='sub-desc'><p>in ISO format</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>callInputChanged</span> : Boolean<div class='sub-desc'><p>If true the function ´inputChanged´ will be called</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-setMainHeader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-setMainHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-setMainHeader' class='name expandable'>setMainHeader</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Set main header if class is set. ...</div><div class='long'><p>Set main header if class is set.</p>\n</div></div></div><div id='method-setResponsive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-setResponsive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-setResponsive' class='name expandable'>setResponsive</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Set responsive flag if class is set. ...</div><div class='long'><p>Set responsive flag if class is set.</p>\n</div></div></div><div id='method-setSuccessor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-setSuccessor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-setSuccessor' class='name expandable'>setSuccessor</a>( <span class='pre'>successorNodeId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Set successor node ...</div><div class='long'><p>Set successor node</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>successorNodeId</span> : String<div class='sub-desc'><p>Successor node id</p>\n</div></li></ul></div></div></div><div id='method-showColumn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-showColumn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-showColumn' class='name expandable'>showColumn</a>( <span class='pre'>columnName, show, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Show or hides a column ...</div><div class='long'><p>Show or hides a column</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'><p>Column name</p>\n</div></li><li><span class='pre'>show</span> : Boolean<div class='sub-desc'><p>Show column</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>clear</span> : Boolean (optional)<div class='sub-desc'><p>Clear fields</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>numberOfHeaderLines</span> : Boolean (optional)<div class='sub-desc'><p>Number of header lines</p>\n<p>Defaults to: <code>1</code></p></div></li></ul></div></li></ul></div></div></div><div id='method-showColumns' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-showColumns' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-showColumns' class='name expandable'>showColumns</a>( <span class='pre'>columnNames, show, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Shows or hides columns ...</div><div class='long'><p>Shows or hides columns</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnNames</span> : Array<div class='sub-desc'><p>Column names</p>\n</div></li><li><span class='pre'>show</span> : Boolean<div class='sub-desc'><p>Show columns</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n</div></li></ul></div></div></div><div id='method-showRows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-showRows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-showRows' class='name expandable'>showRows</a>( <span class='pre'>columnName, callback</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Shows or hides a row ...</div><div class='long'><p>Shows or hides a row</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : String<div class='sub-desc'><p>Column name</p>\n</div></li><li><span class='pre'>callback</span> : Function<div class='sub-desc'><p>Callback</p>\n</div></li></ul></div></div></div><div id='method-showTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-showTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-showTemplate' class='name expandable'>showTemplate</a>( <span class='pre'>field</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Shows a template ...</div><div class='long'><p>Shows a template</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li></ul></div></div></div><div id='method-showTemplateListWarning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-showTemplateListWarning' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-showTemplateListWarning' class='name expandable'>showTemplateListWarning</a>( <span class='pre'>labelName, entries, entries, entries</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Insert list ...</div><div class='long'><p>Insert list</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>labelName</span> : String<div class='sub-desc'><p>Label name</p>\n</div></li><li><span class='pre'>entries</span> : Array<div class='sub-desc'><p>Entries</p>\n</div></li><li><span class='pre'>entries</span> : String<div class='sub-desc'><p>[].text Text</p>\n</div></li><li><span class='pre'>entries</span> : Object<div class='sub-desc'><p>[].params Parameters</p>\n</div></li></ul></div></div></div><div id='method-sumItems' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-sumItems' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-sumItems' class='name expandable'>sumItems</a>( <span class='pre'>columnName</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Sums all values of a given column ...</div><div class='long'><p>Sums all values of a given column</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>columnName</span> : string<div class='sub-desc'><p>Name of the column</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-toDecimal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-toDecimal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-toDecimal' class='name expandable'>toDecimal</a>( <span class='pre'>fieldName, params</span> ) : Decimal<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a Decimal data type ...</div><div class='long'><p>Returns a Decimal data type</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>fieldName Field name</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>silent</span> : Boolean<div class='sub-desc'><p>Silent</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Decimal</span><div class='sub-desc'><p>Decimal</p>\n</div></li></ul></div></div></div><div id='method-updateDecimal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-updateDecimal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-updateDecimal' class='name expandable'>updateDecimal</a>( <span class='pre'>fieldName, decimal, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Write a Decimal into an input field ...</div><div class='long'><p>Write a Decimal into an input field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li><li><span class='pre'>decimal</span> : Decimal<div class='sub-desc'><p>Decimal</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>silent</span> : Boolean<div class='sub-desc'><p>Silent</p>\n</div></li><li><span class='pre'>callInputChanged</span> : Boolean<div class='sub-desc'><p>If true the function ´inputChanged´ will be called</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-updateValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-updateValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-updateValues' class='name expandable'>updateValues</a>( <span class='pre'>updates</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Updates values ...</div><div class='long'><p>Updates values</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>updates</span> : Object<div class='sub-desc'><p>Updates\n    {\n        objKeys: {\n        },\n        mapKeys: {\n          \"MYKEY\": \"myvalue\"\n        }\n    }</p>\n</div></li></ul></div></div></div><div id='method-writeDecimalField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-writeDecimalField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-writeDecimalField' class='name expandable'>writeDecimalField</a>( <span class='pre'>field, decimal, decimalPlaces, params</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Writes a Decimal ...</div><div class='long'><p>Writes a Decimal</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : HTMLElement<div class='sub-desc'><p>Field</p>\n</div></li><li><span class='pre'>decimal</span> : Decimal<div class='sub-desc'><p>Decimal</p>\n</div></li><li><span class='pre'>decimalPlaces</span> : Number<div class='sub-desc'><p>Decimal places</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>callInputChanged</span> : Boolean<div class='sub-desc'><p>If true the function ´inputChanged´ will be called</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-writeUpdates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.forms.Utils'>sol.common.forms.Utils</span><br/><a href='source/lib_sol.common.forms.Utils.html#sol-common-forms-Utils-method-writeUpdates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.forms.Utils-method-writeUpdates' class='name expandable'>writeUpdates</a>( <span class='pre'>entries, prefix</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>entries</span> : Object<div class='sub-desc'><p>Entries\n    {\n      \"MYKEY\": \"myvalue\"\n    }</p>\n</div></li><li><span class='pre'>prefix</span> : String<div class='sub-desc'><p>Prefix</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"singleton":true}});